#ifndef __POPUPLIST_H__
#define __POPUPLIST_H__

#include "SexyAppFramework/ListListener.h"
#include "SexyAppFramework/SmartPtr.h"
#include "SexyAppFramework/Widget.h"

namespace Sexy
{

class ListWidget;
class ScrollbarWidget;

SEXY_PTR_FORWARD(DialogSkin);

///////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
class PopupList : public Widget, public ListListener
{
protected:
	ListWidget *mList;
	int mId;
	ListListener *mListener;
	ScrollbarWidget *mScrollbar;
	Widget *mFocusWidget;
	bool mIsOpen;
	std::string mTitle;
	int mTitleHeight;

public:
	PopupList(int theId, ListListener *theListener, Font *theFont = NULL);
	virtual ~PopupList();

	virtual void RemovedFromManager(WidgetManager *theManager);
	virtual void Resize(int x, int y, int width, int height);
	void Open(WidgetManager *theManager, int x, int y, int width, int height, Rect *theAvoidRect = NULL);
	void Close();
	void SetFocusWidget(Widget *theWidget) { mFocusWidget = theWidget; }
	int AddLine(const std::string &theStr, bool alpha = false);
	void SetLine(int theLineNum, const std::string &theVal);
	void SetNumLines(int theNum);
	void SetLineInt(int theIdx, int theInt);
	int	GetLineInt(int theIdx);
	void Clear();
	void SetTitle(const std::string &theTitle);
	void SetSelect(int theSelectIdx);
	bool IsOpen() { return mIsOpen; }

	virtual void Draw(Graphics *g);
	virtual void LostFocus();
	virtual void MouseWheel(int theDelta);
	virtual void KeyDown(KeyCode theKey);
	virtual void ListClicked(int theId, int theIdx, int theClickCount);
	ListWidget* GetList() { return mList; }
};

};

#endif